<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_special_offers extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		$this->modal_name = "offers_model";
		$this->load->model($this->modal_name);
		$this->page ='admin/manage_special_offers/';
		$this->current_url = base_url()."admin/manage_special_offers/";
		$this->table_id = "tblmng_offers";
	}
	
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';		
	}

	public function index()
	{
		$this->grid_resorces();
		$text = "Manage Offers";
		$this->output->set_title(lang($text));
		$this->page_name = lang($text);
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		$this->data['tbl_id']		=	$this->table_id;
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_offers();";
		$this->load->end_inline_scripting(false,false);
		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);
		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');
		$this->datatables->select('o.id,o.title,cg.group_name,o.start_date,o.end_date,o.type,o.price,o.status',false)
		->join('car_groups as cg','cg.id = o.groupId')
		->edit_column('status', '$1', 'get_status(status,id,"")')
		->edit_column('type', '$1', 'get_special_offer_type(type,id)')
		->add_column('cars', '$1', 'get_special_offer_cars(id)')
		->add_column('location', '$1', 'get_special_offers_location(id)')
		->add_column('operation',get_operation_btn('$1',$array),'id')	
		->from('offers as o');
		if($this->isAjax){
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];

		

	}

	public function add()
	{

		$data = array();
		if($this->input->post())
		{
			$groupId = $this->input->post('groupId');
			$title_post = $this->input->post('title');
			$type = $this->input->post('type');
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$price = $this->input->post('price');
			
			$popup_title = $this->input->post('popup_title');
			$popup_desc = $this->input->post('popup_desc');
			
			$where_ar = array("title"=>$title_post,"groupId"=>$groupId);
			$exist_check = $this->{$this->modal_name}->get_by($where_ar);
			if(!empty($exist_check))
			{
				$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
				redirect($this->current_url."add");	
			}
			else{
				$data = array(
					'title' => $title_post,
					'groupId' => $groupId,
					'type' => $type,
					'price' => $price,					
					'start_date' => $start_date,
					'end_date' => $end_date,
					'popup_title' => $popup_title,
					'popup_desc' => $popup_desc,
					'created' => date('Y-m-d H:i:s')					
					);
				$status = $this->{$this->modal_name}->insert($data);
				/*printr($status);
				exit();*/
				if($status)
				{
					$this->session->set_flashdata('success',lang(MSG_REC_ADD));
					redirect($this->current_url);				
				}else{
					$this->session->set_flashdata('error',lang(validation_errors()));
					redirect($this->current_url."add");	
				}				
			}
		}
		if(!$this->input->post())
		{
			$this->load->model("cars_model");
			$this->load->model("car_groups_model");
			$this->load->model("locations_model");

			$this->load->js('js/components-date-time-pickers.js');
			$this->page_type = 'add';
			$text = "Add Special Offer";
			$this->page_name = lang($text);
			$this->output->set_title(lang($text));
			$this->data["form_url"] = $this->current_url."add";


			$this->load->start_inline_scripting();
			echo "Appad.init_common_methods();";
			$this->load->end_inline_scripting(false,false);

			/*$this->data["cars"] = $this->cars_model->set_fields("id,name")->get_many_by('status','y');*/
			$this->data["groups"] = $this->car_groups_model->set_fields("id,group_name")->get_many_by('status','y');
			$this->data["locations"] = $this->locations_model->set_fields("id,location_name")->get_many_by('status','y');


			$this->view = $this->page."add_edit";
		}
	}

	public function edit($id=NULL){
		if($id != NULL && $id > 0){
			$data = array();

			$animeties_array = array("db_sel_cars","db_sel_location");
			$this->data["offer_data"] = $this->{$this->modal_name}->as_array()->get($id);
			if(!empty($animeties_array))
			{
				foreach ($animeties_array as $key => $value) {
					if(!empty($this->data["offer_data"][$value]))
					{
						$this->data["offer_data"][$value."_ids"] = array();
						foreach ($this->data["offer_data"][$value] as $key => $value1) {
							$this->data["offer_data"][$value."_ids"][] = $value1["id"];
						}
						unset($this->data["offer_data"][$value]);
					}	
				}
			}

			/*printr($this->data);
			exit();*/

			if($this->input->post())
			{
				
				$groupId = $this->input->post('groupId');
				$title_post = $this->input->post('title');
				$type = $this->input->post('type');
				$start_date = $this->input->post('start_date');
				$end_date = $this->input->post('end_date');
				$price = $this->input->post('price');
				$popup_title = $this->input->post('popup_title');
				$popup_desc = $this->input->post('popup_desc');

				$where_ar[] = array("title = '".$title_post."' AND groupId = '".$groupId."'",null,false);
				$where_ar[] = array("id != '".$id."'",null,false);
				$exist_check = $this->{$this->modal_name}->get_by($where_ar);
				if(!empty($exist_check))
				{
					$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));
					redirect($this->current_url."edit/".$id);	
				}
				else{				
					$data = array(
						'title' => $title_post,
						'groupId' => $groupId,
						'type' => $type,
						'price' => $price,					
						'start_date' => $start_date,
						'end_date' => $end_date,
						"id"=>$id,
						"popup_title"=>$popup_title,
						"popup_desc"=>$popup_desc,
						"db_sel_cars"=>	$this->data["offer_data"]["db_sel_cars_ids"],					
						"db_sel_location"=>	$this->data["offer_data"]["db_sel_location_ids"]
						);
					if(!empty($data))
					{
						$update_status = $this->{$this->modal_name}->update($id,$data);
						if(!empty($update_status)) 
						{
							$this->session->set_flashdata('success',lang(MSG_REC_EDIT));
							redirect($this->current_url,"refresh");
						}else{
							$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));
							redirect($this->current_url.'edit/'.$id,"refresh");
						}
					}					
				}
			}
			else if(!$this->input->post())
			{

				$this->load->js('js/components-date-time-pickers.js');
				if($this->data["offer_data"])
				{
					$this->load->model("cars_model");
					$this->load->model("car_groups_model");
					$this->load->model("locations_model");
					$text = "Edit Offer - ".$this->data["offer_data"]["title"];
					$this->page_type = 'edit';
					$this->page_name = lang($text);
					$this->output->set_title(lang($text));
					$this->data["form_url"] = $this->current_url.'edit/'.$id;	
					$this->data["action"] = "edit";
					$this->data["groups"] = $this->car_groups_model->set_fields("id,group_name")->get_many_by('status','y');
					$this->data["locations"] = $this->locations_model->set_fields("id,location_name")->get_many_by('status','y');

					$this->data["cars"] = $this->cars_model->set_fields("id,name")->get_many_by('groupId',$this->data["offer_data"]["groupId"]);
					
					$file_path = FCPATH."assets/upload/offers/".$this->data["offer_data"]["image"];

					if(file_exists($file_path) && $file_path!="")
					{
						$this->data["image_url"] = base_url()."assets/upload/offers/".$this->data["offer_data"]["image"];
					}
					$this->load->start_inline_scripting();
					echo "Appad.init_common_methods();";
					$this->load->end_inline_scripting(false,false);
					$this->view = $this->page."add_edit";
				}
				else{
					$this->session->set_flashdata("error",lang(INVALID_REQUEST));
					redirect(base_url().$this->page,"refresh");
				}
			}
		}
	}

	public function change_status()
	{
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$offer_id = $this->input->post('offer_id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			if($offer_id > 0){
				$this->status_data = $this->{$this->modal_name}->set_fields("id,status")->as_array()->get($offer_id);
				if(!empty($this->status_data))
				{
					if($this->status_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->{$this->modal_name}->update($offer_id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}

	public function delete($id){

		$this->data["status"] = "fail";
		$this->data["msg"] = "Please try again.";
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0){
			$del_status = $this->{$this->modal_name}->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang(MSG_REC_DELETE);
				$this->data["table"] = $this->table_id;
			}
		}
	}
}
