<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once(FCPATH."application/controllers/booking.php");
class Manage_season_working_hours extends My_Controller
{
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		$this->from_admin = "true";
		parent::__construct();
		$this->_init();		
		$this->page ='admin/manage_season_working_hours/';
		$this->current_url = base_url()."admin/manage_season_working_hours/";
	}

	private function _init()
	{
		$admin  =   $this->session->userdata(ADMIN_SESS_NM);
		if(!isset($admin) || empty($admin))
		{
			$this->session->set_flashdata("error",lang("INVALID_REQUEST"));
			redirect(base_url()."admin");
			exit();
		}
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';
	}
	public function index()
	{	
		$this->load->js('js/components-date-time-pickers.js');
		$this->load->model("season_model");
		$this->load->model("locations_model");
		$this->grid_resorces();
		$this->page_name = lang("Manage Season Working Time");
		$this->output->set_title(lang("Manage Season Woring Time"));
		$this->load->js('plugins/datatables/jquery.dataTables.min.js');
		$this->data['page_url']	=	'manage_booking';
		$this->data['tbl_id']		=	'tblmng_season_working_hours';
		$this->data['add_button'] = true;
		$this->data['add_button_href'] = $this->current_url.'add';
		
		$this->data['seasons'] =	$this->season_model->get_many_by('status','y');
		$this->locations_model->after_get_allow = false;
		$this->data["locations"] = $this->locations_model->get_many_by('status','y');
		$this->locations_model->after_get_allow = true;
		$this->data["season_working_hour_page"] = true;

		$this->view = "layouts/admin/datatable";		
		$editurl = $this->current_url."edit";
		$deleteurl = $this->current_url."delete";
		
		$array = array('edit'=>$editurl,'delete'=>$deleteurl);

		$this->load->library('Datatables');
		$this->load->helper('datatable_helper');		
		$this->datatables->select('slwh.id,s.season_name,l.location_name,slwh.working_from,slwh.working_to,slwh.status',false)
		->join('season as s','s.id = slwh.seasonId')
		->join('locations as l','l.id = slwh.locationId')
		->edit_column('status', '$1', 'get_status(status,id,"manage_season_working_hours/change_user_status")')
		->add_column('operation',get_operation_btn('$1',$array,null,null,null,null,'$2'),'id,api_reservation_id')	
		->from('season_location_working_hours as slwh');
		
		$season = $this->input->get("season");
		$location = $this->input->get("location");
		if($season > 0){
			$this->datatables->where('seasonId =', $season);
		}

		if($location > 0){
			$this->datatables->where('locationId =', $location);
		}

		$this->load->start_inline_scripting();
		echo "Appad.init_mng_season_working_hours();";
		$this->load->end_inline_scripting(false,false);

		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			echo $this->datatables->generate();
			exit;
		}
		$results = $this->datatables->generate('raw');
		$this->data['columns'] = $results['columns'];
	}
	
	public function add()
	{	
		if($this->input->post())
		{
			$this->load->model("season_location_working_hours_model");
			$seasonId = $this->input->post("seasonId");
			$working_from = $this->input->post("working_from");
			$working_to = $this->input->post("working_to");

			if(!empty($working_from))
			{
				$insert_timing_ar = array();
				$i = 1;
				foreach ($working_from as $key => $value) 
				{
					$locationId = $key;
					$working_from_time = $value;
					$working_to_time = $working_to[$key];

					/*check exists*/
					$check_where = array(
						"seasonId"=>$seasonId,
						"locationId"=>$locationId
					);
					$check_exists = $this->season_location_working_hours_model->get_by($check_where);

					if(!empty($check_exists))
					{
						continue;
					}
					/*check exists*/

					if($locationId > 0 && $working_from_time != '' && $working_to_time != '')
					{
						$insert_timing_ar[$i]["seasonId"] = $seasonId;
						$insert_timing_ar[$i]["locationId"] = $locationId;
						$insert_timing_ar[$i]["working_from"] = $working_from_time;
						$insert_timing_ar[$i]["working_to"] = $working_to_time;
						$insert_timing_ar[$i]["created_date"] = date("Y-m-d H:i:s");
						$i++;
					}
				}

				if(!empty($insert_timing_ar))
				{
					$insert_ids = $this->season_location_working_hours_model->insert_many($insert_timing_ar);

					if($insert_ids)
					{
						$this->session->set_flashdata("success",lang(MSG_REC_ADD));
						redirect($this->current_url);
						exit();
					}
				}
				else
				{
					$this->session->set_flashdata("success",lang(MSG_REC_ADD));
					redirect($this->current_url);
					exit();
				}
			}
		}

		if(!$this->input->post())
		{
			$this->load->model("season_model");
			$this->load->model("locations_model");
			$this->page_type = 'add';
			$this->page_name = lang("Add Season Working Hour");
			$this->output->set_title(lang("Add Season Working Hour"));
			$this->locations_model->after_get_allow = false;
			$this->data['locations'] =	$this->locations_model->get_many_by('status','y');
			$this->locations_model->after_get_allow = true;

			$this->data['seasons'] =	$this->season_model->get_many_by('status','y');

			$this->data['page_url']				=	'manage_contents/add';
			$this->data['form_url']	= $this->current_url.'add';	
			$this->data["type"] = "add";			
		}
		$this->view = $this->page."add_edit";		
	}

	public function edit($id)
	{
		$where = array('id'=>$id);
		$this->load->model("season_location_working_hours_model");
		$this->season_location_working_hours_model->after_get_allow = true;
		$working_hour_data = $this->season_location_working_hours_model->get_by($where);
		$this->season_location_working_hours_model->after_get_allow = false;
		if(!empty($working_hour_data))
		{
			if($this->input->post())
			{
				$this->load->model("season_location_working_hours_model");
				$seasonId = $this->input->post("seasonId");
				$working_from = $this->input->post("working_from");
				$working_to = $this->input->post("working_to");

				if(!empty($working_from))
				{
					$insert_timing_ar = array();
					$i = 1;
					foreach ($working_from as $key => $value) 
					{
						$locationId = $key;
						$working_from_time = $value;
						$working_to_time = $working_to[$key];
						$check_where = array(
							"seasonId"=>$seasonId,
							"locationId"=>$locationId
						);
						$check_exists = $this->season_location_working_hours_model->get_by($check_where);

						if(!empty($check_exists))
						{
							$update_array = array(
								"working_from" => $working_from_time,
								"working_to" => $working_to_time
							); 
							$update_status = $this->season_location_working_hours_model->update($check_exists["id"],$update_array,true);
						}
						else if($locationId > 0 && $working_from_time != '' && $working_to_time != '')
						{
							$insert_timing_ar[$i]["seasonId"] = $seasonId;
							$insert_timing_ar[$i]["locationId"] = $locationId;
							$insert_timing_ar[$i]["working_from"] = $working_from_time;
							$insert_timing_ar[$i]["working_to"] = $working_to_time;
							$insert_timing_ar[$i]["created_date"] = date("Y-m-d H:i:s");
							$i++;
						}
					}

					if(!empty($insert_timing_ar))
					{
						$insert_ids = $this->season_location_working_hours_model->insert_many($insert_timing_ar);
						if($insert_ids)
						{
							$this->session->set_flashdata("success",lang(MSG_REC_ADD));
							redirect($this->current_url);
							exit();
						}
					}
					$this->session->set_flashdata("success",lang(MSG_REC_EDIT));
					redirect($this->current_url);
					exit();
				}
				else
				{
					$this->session->set_flashdata("error",lang(SOMETHING_WENT_WRONG));
					redirect($this->current_url);
					exit();
				}
			}

			if(!$this->input->post())
			{
				$this->load->model("locations_model");
				$this->load->model("season_model");
				$this->locations_model->after_get_allow = false;
				$this->data['locations'] =	$this->locations_model->get_many_by('status','y');
				$this->locations_model->after_get_allow = true;
				$this->data['seasons'] =	$this->season_model->get_many_by('status','y');

				$this->data["formurl"] = base_url().'admin/manage_season_working_hours/edit/'.$id;
				
				$this->view = $this->page."add_edit";
				$this->data["action"] = "edit";

				$this->page_name = " Change ".$this->data['season_detail']["season_name"]." working hours for : ".$this->data['location_detail']["location_name"];
				$this->data["working_hour_data"] = $working_hour_data;
			}
		}
		else
		{
			redirect($this->current_url);
		}
	}

	public function delete($id)
	{
		$this->load->model("season_location_working_hours_model");
		$this->data["status"] = "fail";
		$this->data["msg"] = lang("PLEASE_TRY_AGAIN");
		$this->view = false;
		$this->layout = false;
		$this->json = true;
		if($id > 0)
		{
			$del_status = $this->season_location_working_hours_model->delete($id);
			if($del_status)
			{
				$this->data["status"] = "success";
				$this->data["msg"] = lang("MSG_REC_DELETE");
				$this->data["table"] = "tblmng_season_working_hours";
			}
		}
	}


	public function change_status(){
		if($this->isAjax)
		{
			$this->layout=false;
			$this->view=false;
			$this->json=true;	
			$this->data["status"] = "fail";
			$this->data["msg"] = "";		
			$id = $this->input->post('id');
			$upd_status = 'n';
			$msg_constant = MSG_REC_DEACTIVE;
			$this->load->model("season_location_working_hours_model");
			if($id > 0){
				$this->season_working_data = $this->season_location_working_hours_model->set_fields("id,status")->as_array()->get($id);

				if(!empty($this->season_working_data))
				{
					if($this->season_working_data['status'] == 'n'){
						$upd_status = 'y';
						$msg_constant = MSG_REC_ACTIVE;
					}
					$update_array = array('status' => $upd_status);
					$response = $this->season_location_working_hours_model->update($id,$update_array,true);
					$this->data["status"] = "success";
					$this->data["msg"] = lang($msg_constant);	
				}
			}
		}
	}
}
