<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Manage_pricing_import_export extends MY_Controller {
	function __construct()
	{
		$this->login_type	= 'admin';
		$this->access   = 'login';
		parent::__construct();
		$this->_init();
		//$this->load->model("content_model");
		$this->page ='admin/manage_pricing_import_export/';
		$this->current_url = base_url()."admin/manage_pricing_import_export/";
	}
	private function _init()
	{
		$this->sections['section_header'] = 'sections/admin/header';
		$this->sections['section_sidebar'] = 'sections/admin/menu';
		$this->sections['section_footer'] = 'sections/admin/footer';
		$this->load->library('excel');
		$this->load->model('user_model');
		$this->load->model('categories_model');
		$this->load->model('rental_days_model');
		$this->load->model('day_price_model');
		$this->load->model('pricing_model');
		$this->load->model("season_model");
	}
	public function index()
	{	
		$this->page_name = lang("Pricing Import / Export");
		$this->output->set_title(lang("Pricing Import / Export"));
		$this->data['export_button_href'] = $this->current_url.'export';
		$this->data['form_url'] = $this->current_url.'import';
		$this->load->start_inline_scripting();
		echo "Appad.init_mng_content_list();";
		$this->load->end_inline_scripting(false,false);
	}
	public function import()
	{
		$this->view = false;
		$this->layout = false;
		$basic_price_sheet_tested = true;
		if($_FILES['file'])
		{
			$status_ar = $this->upload_image();
			if($status_ar["status"] == "success")
			{
				$file_path = FCPATH."assets/upload/pricing/pricing.xls";
				$objPHPExcel = PHPExcel_IOFactory::load($file_path);
				$objPHPExcel->setActiveSheetIndex(0);
				$cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
				foreach ($cell_collection as $cell) 
				{
					$column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
					$row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
					$data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
					
					if ($row == 1) {
						$header[$row][$column] = $data_value;
					} else {
						$arr_data[$row][$column] = $data_value;
					}
				}
				$basic_pricing_ar['header'] = $header;
				$basic_pricing_ar['values'] = $arr_data;

				/*printr($basic_pricing_ar);*/
				

				/*Advanced Pricing*/
				$objPHPExcel->setActiveSheetIndex(1);
				$cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();

				foreach ($cell_collection as $cell)
				{
					$column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
					$row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
					$data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
					if($row == 1) 
					{
						$header[$row][$column] = $data_value;
					} 
					else
					{
						$arr_data[$row][$column] = $data_value;
					}
				}
				$advanced_pricing_ar['header'] = $header;
				$advanced_pricing_ar['values'] = $arr_data;	
				/*Advanced Pricing ends*/
			}
		}
		
		/* Test basic sheet if ok then process */
		if(!empty($basic_pricing_ar["values"]))
		{
			foreach ($basic_pricing_ar["values"] as $key_basic => $value_basic) 
			{
				if(!empty($value_basic))
				{
					$m = 1;
					foreach ($value_basic as $key_in => $value_in) 
					{
						if($m == 3)
						{
							if($value_in == "" || $value_in == NULL)
							{
								$basic_price_sheet_tested = false;			
							}
						}
						$m++;
					}
				}
			}
		}
		
		/*printr($basic_pricing_ar);
		exit();*/

		
		/* Test basic sheet if ok then process */
		if($basic_price_sheet_tested == true)
		{
			
			if(!empty($basic_pricing_ar["header"]))
			{
				foreach ($basic_pricing_ar["header"][1] as $key => $value) {
					$explode_ar = explode(" - ",$value);
					if(!empty($explode_ar))
					{
						if(count($explode_ar) > 1)
						{
							$basic_pricing_key_holder[$key] =  $explode_ar[1];		
						}else{
							$basic_pricing_key_holder[$key] =  $explode_ar[0];		
						}
					}
				}
			}

			if(!empty($advanced_pricing_ar["header"]))
			{
				foreach ($advanced_pricing_ar["header"][1] as $key => $value) {
					$explode_ar = explode(" - ",$value);
					if(!empty($explode_ar))
					{
						if(count($explode_ar) > 1)
						{
							$advanced_pricing_key_holder[$key] =  $explode_ar[1];		
						}else{
							$advanced_pricing_key_holder[$key] =  $explode_ar[0];		
						}
					}
				}
			}

			
			
			/*Insert or update basic pricing values*/
			if(!empty($basic_pricing_ar["values"]))
			{
				foreach ($basic_pricing_ar["values"] as $key_basic => $value_basic) 
				{

					if(!empty($value_basic))
					{
						$bm = 1;
						foreach ($value_basic as $key_in => $value_in) 
						{
							if($bm == 1)
							{
								$where_p_ar = array('type'=>'b','categoryId'=>$value_in);
								$pricing_ar = $this->pricing_model->set_fields("id")->get_by($where_p_ar);	

								if(empty($pricing_ar))
								{
									$insert_data = array(
										'categoryId' => $value_in,
										'type' => 'b',
										'seasonId' => '0',
										'created' => date('Y-m-d H:i:s'),
										'updated' => date('Y-m-d H:i:s')
										);
									$pricing_id = $this->pricing_model->insert($insert_data,true);
								}
								else{
									$pricing_id = $pricing_ar["id"];						
								}
							}	
							if($bm > 2)
							{
								$day_id = $basic_pricing_key_holder[$key_in];

								$day_id_ar = $this->rental_days_model->set_fields("id")->get_by("day",$day_id);
								$day_id = $day_id_ar["id"];
								
								$where_p_ar = array('dayId'=>$day_id,'pricingId'=>$pricing_id);
								$day_price_ar = $this->day_price_model->set_fields("id")->get_by($where_p_ar);	
								if($value_in > 0)
								{

									$insert_update_data = array(
										'pricingId' => $pricing_id,
										'dayId' => $day_id,
										'price' => $value_in
										);

									/*printr($insert_update_data);*/

									if(empty($day_price_ar))
									{
										$this->day_price_model->insert($insert_update_data,true);
									}
									else
									{
										$this->day_price_model->update($day_price_ar["id"],$insert_update_data,true);
									}	
								}
								else
								{
									/*echo "\n Delete from here".$day_price_ar["id"];*/

									$this->day_price_model->delete($day_price_ar["id"]);
								}
							}
							$bm++;
						}
					}
				}
			}
			/*Insert or update basic pricing values*/

			/*Insert or update advanced pricing*/
			if(!empty($advanced_pricing_ar["values"]))
			{
				foreach ($advanced_pricing_ar["values"] as $key_advanced => $value_advanced) 
				{
					if(!empty($value_advanced))
					{
						$m = 1;
						foreach ($value_advanced as $key_in => $value_in) 
						{
							if($m == 1)
							{
								$category_id = $value_in;
							}	
							if($m == 2)
							{
								$season_id = $value_in;
							}
							if($m == 3)
							{
								$where_p_ar = array(
									'type'=>'a',
									'categoryId'=>$category_id,
									'seasonId'=>$season_id
									);
								$pricing_ar = $this->pricing_model->set_fields("id")->get_by($where_p_ar);
								if(!empty($pricing_ar))
								{
									$pricing_id = $pricing_ar["id"];	
								}
								else
								{
									$pricing_id = 0;
								}
							}
							if($m > 4)
							{
								$day_id = $advanced_pricing_key_holder[$key_in];

								$day_id_ar = $this->rental_days_model->set_fields("id")->get_by("day",$day_id);
								$day_id = $day_id_ar["id"];
								
								/*Custom J 1*/
								$where_p_ar = array(
									'type'=>'a',
									'categoryId'=>$category_id,
									'seasonId'=>$season_id
									);
								$pricing_ar = $this->pricing_model->set_fields("id")->get_by($where_p_ar);
								if(!empty($pricing_ar))
								{
									$pricing_id = $pricing_ar["id"];	
								}
								else
								{
									$pricing_id = 0;
								}

								/*Custom J 1*/
								if($pricing_id > 0)
								{
									$where_p_ar = array(
										'dayId'=>$day_id,
										'pricingId'=>$pricing_id
										);
									$day_price_ar = $this->day_price_model->set_fields("id")->get_by($where_p_ar);
								}

								if($value_in > 0)
								{
									/*Custom J*/
									if(empty($pricing_ar))
									{
										$insert_data = array(
											'categoryId' => $category_id,
											'seasonId' => $season_id,
											'type' => 'a',
											'created' => date('Y-m-d H:i:s'),
											'updated' => date('Y-m-d H:i:s')
											);
										$pricing_id = $this->pricing_model->insert($insert_data,true);
									}
									else{
										$pricing_id = $pricing_ar["id"];
									}

									/*Custom */
									$insert_update_data = array(
										'pricingId' => $pricing_id,
										'dayId' => $day_id,
										'price' => $value_in
										);

									if(empty($day_price_ar))
									{
										$this->day_price_model->insert($insert_update_data,true);
									}
									else{
										$this->day_price_model->update($day_price_ar["id"],$insert_update_data,true);
									}	
								}
								else
								{
									if(!empty($day_price_ar))
									{

										/*echo "\n\n\Pricing Id => ".$pricing_id;
										echo "\n\n\array ";
										printr($day_price_ar);;

										echo "\n\n\nDel".$day_price_ar["id"];*/
										/*Delete code check*/
										$this->day_price_model->delete($day_price_ar["id"]);	
										/*Delete code check*/
									}
									
								}
							}
							
							$m++;
						}

						

					}
					else{

					}
				}
			}
			/*Insert or update advanced pricing ends*/

			$this->session->set_flashdata("success",lang("PRICE_UPDATED_SUCCESSFULLY"));
		}
		else{
			$this->session->set_flashdata("error",lang("FILL_BASIC_VALUE_OF_ALL_CATEGORY"));
		}
		unlink($file_path);
		redirect($this->current_url,"redirect");
		/*printr($basic_pricing_key_holder);
		printr($advanced_pricing_key_holder);
		printr($basic_pricing_ar);
		printr($advanced_pricing_ar);
		exit();*/
	}
	public function upload_image()
	{
		$asset_upload_dir = FCPATH.'assets/upload/'; 
		$upload_dir = FCPATH.'assets/upload/pricing/'; 
		if(!file_exists($asset_upload_dir)){
			mkdir($asset_upload_dir,777);
		}
		if(!file_exists($upload_dir)){
			mkdir($upload_dir,0777);
		}	
		$data = array('status'=>'error');
		$maxSize = IMAGE_UPLOAD_MAX_SIZE;
		if($_FILES['file']['error']==UPLOAD_ERR_OK){
			$this->load->library('image_lib');
			$name = $_FILES['file']['name'];
			$size = $_FILES['file']['size'];
			$ext = substr($name, strrpos($name, ".") + 1);
			if ($size < ($maxSize)) {
				$th_arr=array();	
				$config['upload_path'] = $upload_dir;
				$config['file_name'] ="pricing";
				$config['allowed_types'] = '*';
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
				$field_name = "file";
				if ( ! $this->upload->do_upload($field_name))
				{
					$this->form_validation->set_message('insert',$this->upload->display_errors());
					$data["status"] = "error";
					$data["msg"] = $this->upload->display_errors();					
				}
				else
				{
					$fileUpd = array('upload_data' => $this->upload->data());
					$data["status"] = "success";
					$data['file_name'] = $fileUpd['upload_data']['file_name'] ;
				}
			}
			else{
				$this->session->set_flashdata('message','Image size is too large.maximum image size is '.$maxSize);
				$data["status"] = 'error';
				$data["msg"] ='Image size is too large.maximum image size is '.$maxSize;				
			}	
		}
		return $data;
	}
	public function export()
	{

		$this->view = false;
		$this->layout = false;
		$this->load->model('user_model');
		$this->load->model('categories_model');
		$this->load->model('rental_days_model');
		$this->load->model('day_price_model');
		$this->load->model('pricing_model');
		$this->load->model("season_model");
		$this->excel->setActiveSheetIndex(0);
		$this->excel->getActiveSheet()->setTitle('Basic');
		$pricing_array = array();
		$categories_data = $this->categories_model->get_all();
		$rental_days_data = $this->rental_days_model->order_by("day")->get_all();
		$categories_count = count($categories_data);
		$rental_days_count = count($rental_days_data);
		$abcd_ar = array();
		$counter = 1;
		for ($j = 'C'; $j <= 'Z'; $j++)
		{
			if($counter <= $rental_days_count)
			{
				$abcd_ar[] = $j; 		
			}
			if($counter > $rental_days_count)
			{
				break;
			}
			$counter++;
		}
		$counter = 1;
		for ($k = 'E'; $k <= 'Z'; $k++)
		{
			if($counter <= $rental_days_count)
			{
				$advanced_abcd_ar[] = $k; 			
			}
			if($counter > $rental_days_count)
			{
				break;
			}
			$counter++;
		}


		$pricing_array[0] = array("id","Name");
		if(!empty($rental_days_data))
		{
			$days_seqence = array();
			foreach ($rental_days_data as $key => $value) 
			{
				$temp = $key + 2;
				$pricing_array[0][] = "Day - ".$value["day"];
				$days_seqence[$temp] = $value["id"];
			}
		}

		
		/*
		printr($days_seqence);
		printr($categories_data);
		exit();*/
		if(!empty($categories_data))
		{	
			$i = 1;
			foreach ($categories_data as $key => $cat) 
			{
				/*printr($cat);*/
				$pricing_array[$i][] = $cat["id"];
				$pricing_array[$i][] = $cat["category"];
				$where_p_ar = array('type'=>'b','categoryId'=>$cat["id"]);
				$pricing_ar = $this->pricing_model->set_fields("id")->set_fields("id")->get_by($where_p_ar);	
				$pricing_id = $pricing_ar["id"];
				$day_price_detail = $this->day_price_model->get_many_by('pricingId',$pricing_id);
				

				if(!empty($day_price_detail))
				{
					foreach ($day_price_detail as $key1 => $value) 
					{

						$key_excel = array_search($value["dayId"], $days_seqence);	
						if($key_excel > 0)
						{
							$pricing_array[$i][$key_excel] = $value["price"];	
						}
					}

					if(!empty($days_seqence))
					{
						foreach ($days_seqence as $k => $v) 
						{
							
							if(!isset($pricing_array[$i][$k]))	
							{
								$pricing_array[$i][$k] = '';	
							}
						}
					}
					ksort($pricing_array[$i]);
				}
				$i++;
			}
		}

		$this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(30);
		$this->excel->getActiveSheet()->getProtection()->setSheet(true);
		if(!empty($abcd_ar))
		{
			foreach ($abcd_ar as $key => $value_abcd) 
			{
				$this->excel->getActiveSheet()->getStyle($value_abcd.'2:'.$value_abcd.($categories_count+1))->getProtection()->setLocked(PHPExcel_Style_Protection::PROTECTION_UNPROTECTED);
			}
		}

		$this->excel->getActiveSheet()->fromArray($pricing_array);
		$this->excel->createSheet();

		
		$this->excel->setActiveSheetIndex(1); 
		$this->excel->getActiveSheet()->setTitle('Advanced');
		$advanced_pricing_array = array();
		$seasons = $this->season_model->get_all();
		$seasons_count = count($seasons);
		$advanced_pricing_array[0] = array("id","season_id","Name","Season");
		if(!empty($rental_days_data))
		{
			$days_seqence = array();
			foreach ($rental_days_data as $key => $value) 
			{
				$temp = $key + 4;
				$advanced_pricing_array[0][] = "Day - ".$value["day"];
				$days_seqence[$temp] = $value["id"];
			}
		}
		if(!empty($categories_data))
		{	
			$i = 1;
			foreach ($categories_data as $key => $cat) 
			{
				if(!empty($seasons))
				{
					foreach ($seasons as $key => $season) 
					{
						$advanced_pricing_array[$i][] = $cat["id"];
						$advanced_pricing_array[$i][] = $season["id"];						
						$advanced_pricing_array[$i][] = $cat["category"];
						$advanced_pricing_array[$i][] = $season["season_name"];
						$where_p_ar = array('type'=>'a','categoryId'=>$cat["id"],'seasonId'=>$season["id"]);
						$pricing_ar = $this->pricing_model->set_fields("id")->set_fields("id")->get_by($where_p_ar);	
						$pricing_id = $pricing_ar["id"];
						$day_price_detail = $this->day_price_model->get_many_by('pricingId',$pricing_id);
						if(!empty($day_price_detail))
						{
							foreach ($day_price_detail as $key1 => $value) 
							{
								$key_excel = array_search($value["dayId"], $days_seqence);	
								if($key_excel > 0)
								{
									$advanced_pricing_array[$i][$key_excel] = $value["price"];	
								}
							}


							if(!empty($days_seqence))
							{
								foreach ($days_seqence as $k => $v) 
								{

									if(!isset($advanced_pricing_array[$i][$k]))	
									{
										$advanced_pricing_array[$i][$k] = '';	
									}
								}
							}
							ksort($advanced_pricing_array[$i]);

						}
						$i++;
					}
				}	
			}
		}
		$this->excel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
		$this->excel->getActiveSheet()->getProtection()->setSheet(true);
		if(!empty($advanced_abcd_ar))
		{
			foreach ($advanced_abcd_ar as $key => $value_abcd) 
			{
				$this->excel->getActiveSheet()->getStyle($value_abcd.'2:'.$value_abcd.(($categories_count*$seasons_count)+1))->getProtection()->setLocked(PHPExcel_Style_Protection::PROTECTION_UNPROTECTED);
			}
		}
		$this->excel->getActiveSheet()->fromArray($advanced_pricing_array);

		$this->excel->setActiveSheetIndex(0); 
		$filename = 'pricing.xls'; 
		header('Content-Type: application/vnd.ms-excel'); 
		header('Content-Disposition: attachment;filename="'.$filename.'"'); 
		header('Cache-Control: max-age=0'); 
		$objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
		$objWriter->save('php://output');
	}
}
