<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_pickup_locations extends MY_Controller {

	function __construct()

	{

		$this->login_type	= 'admin';

		$this->access   = 'login';

		parent::__construct();

		$this->_init();

		$this->load->model("locations_model");

		$this->page ='admin/manage_pickup_locations/';

		$this->current_url = base_url()."admin/manage_pickup_locations/";

	}

	private function _init()

	{

		$this->sections['section_header'] = 'sections/admin/header';

		$this->sections['section_sidebar'] = 'sections/admin/menu';

		$this->sections['section_footer'] = 'sections/admin/footer';		

	}

	public function index()

	{

		$this->grid_resorces();

		$this->output->set_title(lang("Manage Pickup Location"));

		$this->page_name = lang("Manage Pickup Location");

		$this->data['page_url']	=	'manage_pickup_location';

		$this->data['add_button'] = true;

		$this->data['add_button_href'] = $this->current_url.'add';

		$this->data['tbl_id']		=	'tblmng_pickup_location';

		$this->load->start_inline_scripting();

		echo "Appad.init_mng_pickup_locations();";

		$this->load->end_inline_scripting(false,false);

		$this->view = "layouts/admin/datatable";		

		$editurl = $this->current_url."edit";

		$deleteurl = $this->current_url."delete";

		$array = array('edit'=>$editurl,'delete'=>$deleteurl);

		$this->load->library('Datatables');

		$this->load->helper('datatable_helper');

		$this->datatables->select('l.id,l.location_name,l.location_short_name,l.email,l.phone,c.city_name,s.state_name,co.country_name,l.address,l.zip_code,l.status',false)

		->join('countries as co','co.id = l.country',"left")

		->join('states as s','s.id = l.state',"left")

		->join('cities as c','c.id = l.city',"left")

		->edit_column('status', '$1', 'get_status(status,id,"")')

		->add_column('operation',get_operation_btn('$1',$array),'id')

		->from('locations as l');

		if($this->isAjax){

			$this->layout = false;

			$this->view = false;

			echo $this->datatables->generate();

			exit;

		}

		$results = $this->datatables->generate('raw');

		$this->data['columns'] = $results['columns'];

	}

	public function add()

	{

		$data = array();

		if($this->input->post())

		{

			

			$location_name    = $this->input->post('location_name');

			$location_short_name    = $this->input->post('location_short_name');			

			$location_type    = $this->input->post('location_type');

			$meta_keyword     = $this->input->post('meta_keyword');

			$meta_desc        = $this->input->post('meta_desc');

			$email            = $this->input->post('email');

			$phone            = $this->input->post('phone');

			$fax              = $this->input->post('fax');

			$opening_days     = $this->input->post('opening_days');

			$opening_from     = $this->input->post('opening_from');

			$opening_to       = $this->input->post('opening_to');

			$working_from     = $this->input->post('working_from');

			$working_to       = $this->input->post('working_to');

			$description      = $this->input->post('description');

			

			$direction_desk      = $this->input->post('direction_desk');

			$location_note      = $this->input->post('location_note');

			$location_manager      = $this->input->post('location_manager');



			$country          = $this->input->post('country');

			$state_name       = $this->input->post('state'); 

			$city        	  = $this->input->post('city');

			$address          = $this->input->post('address');

			$zip_code         = $this->input->post('zip_code');

			$latitude         = $this->input->post('latitude');

			$longitude       = $this->input->post('longitude');

			$google_place_id  = $this->input->post('google_place_id');

			$at_home          = ($this->input->post('at_home') == "1") ? "1" : "0";



			$where_ar = array('location_name'=>$location_name);

			$exist_check = $this->locations_model->get_by($where_ar);

			if(!empty($exist_check))

			{

				$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));

				redirect($this->current_url."add");	

			}

			else{				

				$data = array(

					'location_name' =>  $location_name,

					'location_short_name' =>  $location_short_name,					

					'location_type' =>  $location_type,

					'location_image'=>  $old_location_img,

					'meta_keyword'  =>  $meta_keyword,

					'meta_desc'     =>  $meta_desc,

					'description'   =>  $description,

					'direction_desk'   =>  $direction_desk,

					'location_note'   =>  $location_note,

					'location_manager'   =>  $location_manager,

					'email'         =>  $email,

					'phone'         =>  $phone,

					'fax'           =>  $fax,

					'opening_days'  =>  $opening_days,

					'opening_from'  =>  $opening_from,

					'opening_to'    =>  $opening_to,

					'working_from'  =>  $working_from,

					'working_to'    =>  $working_to,

					'country'       =>  $country,

					'state'         =>  $state_name,

					'city'          =>  $city,

					'address'       =>  $address,

					'zip_code'      =>  $zip_code,

					'latitude'      =>  $latitude,

					'longitude'     => $longitude,

					'google_place_id'=>$google_place_id,

					'at_home'       => $at_home

					);

				$status = $this->locations_model->insert($data);



				if($status)

				{

					$this->session->set_flashdata('success',lang(MSG_REC_ADD));

					redirect($this->current_url);				

				}else{

					$this->session->set_flashdata('error',lang(validation_errors()));

					redirect($this->current_url."add");	

				}

			}

		}

		if(!$this->input->post())

		{

			$this->load->helper(array('url','language'));

			$this->load->js("plugins/ckeditor/ckeditor.js");

			$this->load->js("http://maps.googleapis.com/maps/api/js?key=".GOOGLE_MAP_API_KEY."&sensor=false&libraries=places",true);

			$this->page_type = 'add';

			$text = "Add Pickup Location";

			$this->page_name = lang($text);

			$this->output->set_title(lang($text));

			$this->data["form_url"] = $this->current_url."add";

			$this->load->model("countries_model");

			$this->data["countries"] = $this->countries_model->get_all();

			$this->data["country_id"] = 0;

			$this->data["special_offer_image"] = "";

			$this->data["location_image"] = "";

			$this->load->start_inline_scripting();

			echo "Appad.init_mng_cities_operation();";

			echo "Appad.init_common_methods();";			

			$this->load->end_inline_scripting(false,false);

			$this->view = $this->page."add_edit";

		}

	}

	public function edit($id=NULL)

	{

		if($id != NULL && $id > 0){

			$data = array();

			if($this->input->post())

			{

				$location_name    = $this->input->post('location_name');

				$location_short_name    = $this->input->post('location_short_name');



				$location_type    = $this->input->post('location_type');

				$meta_keyword     = $this->input->post('meta_keyword');

				$meta_desc        = $this->input->post('meta_desc');

				$email            = $this->input->post('email');

				$phone            = $this->input->post('phone');

				$fax              = $this->input->post('fax');

				$opening_days     = $this->input->post('opening_days');

				$opening_from     = $this->input->post('opening_from');

				$opening_to       = $this->input->post('opening_to');



				$working_from     = $this->input->post('working_from');

				$working_to       = $this->input->post('working_to');



				$description      = $this->input->post('description');

				$direction_desk      = $this->input->post('direction_desk');

				$location_note      = $this->input->post('location_note');

				$location_manager      = $this->input->post('location_manager');



				$country          = $this->input->post('country');

				$state_name       = $this->input->post('state'); 

				$city        	  = $this->input->post('city');

				$address          = $this->input->post('address');

				$zip_code         = $this->input->post('zip_code');

				$latitude         = $this->input->post('latitude');

				$longitude       = $this->input->post('longitude');

				$google_place_id  = $this->input->post('google_place_id');

				$at_home          = ($this->input->post('at_home') == "1") ? "1" : "0";

				$where_ar = array('location_name'=>$location_name);

				$where_ar[] = array("id != '".$id."'",null,null);

				$exist_check = $this->locations_model->get_by($where_ar);

				if(!empty($exist_check))

				{

					$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));

					redirect($this->current_url."add");	

				}

				else{

					$data = array(

						'location_name' =>  $location_name,

						'location_short_name' =>  $location_short_name,

						'location_type' =>  $location_type,

						'meta_keyword'  =>  $meta_keyword,

						'meta_desc'     =>  $meta_desc,

						'description'   =>  $description,

						'direction_desk'   =>  $direction_desk,

						'location_note'   =>  $location_note,

						'location_manager'   =>  $location_manager,

						'email'         =>  $email,

						'phone'         =>  $phone,

						'fax'           =>  $fax,

						'opening_days'  =>  $opening_days,

						'opening_from'  =>  $opening_from,

						'opening_to'    =>  $opening_to,

						'working_from'  =>  $working_from,

						'working_to'    =>  $working_to,

						'country'       =>  $country,

						'state'         =>  $state_name,

						'city'          =>  $city,

						'address'       =>  $address,

						'zip_code'      =>  $zip_code,

						'latitude'      =>  $latitude,

						'longitude'     => $longitude,

						'google_place_id'=>$google_place_id,

						'at_home'       => $at_home,

						"id" => $id

						);

					if(!empty($data))

					{

						$update_status = $this->locations_model->update($id,$data);



						if(!empty($update_status)) 

						{

							$this->session->set_flashdata('success',lang(MSG_REC_EDIT));

							redirect($this->current_url,"refresh");

						}else{

							$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));

							redirect($this->current_url.'edit/'.$id,"refresh");

						}

					}

				}

			}

			else if(!$this->input->post()){

				$this->data["location_data"] = $this->locations_model->as_array()->get($id);

				if($this->data["location_data"])

				{

					$this->load->helper(array('url','language'));

					$this->load->js("plugins/ckeditor/ckeditor.js");

					$this->load->js("http://maps.googleapis.com/maps/api/js?key=".GOOGLE_MAP_API_KEY."&sensor=false&libraries=places",true);

					$text = "Edit - ".$this->data["location_data"]["location_name"];

					$this->page_type = 'edit';

					$this->page_name = lang($text);

					$this->output->set_title(lang($text));

					$this->data["form_url"] = $this->current_url.'edit/'.$id;	

					$this->load->model("countries_model");

					$this->data["countries"] = $this->countries_model->get_all();

					$this->data["country_id"] = $this->data["location_data"]["country"];	



					$this->load->model("states_model");

					$this->data["states"] = $this->states_model->get_all();

					$this->data["state_id"] = $this->data["location_data"]["state"];



					$this->load->model("cities_model");

					$this->data["city"] = $this->cities_model->get_all();

					$this->data["city_id"] = $this->data["location_data"]["city"];		

					$this->data["action"] = "edit";

					$this->view = $this->page."add_edit";

					

					$path = 'assets/upload/locations/'.$id.'/'.$this->data["location_data"]["location_image"];



					if(!file_exists(FCPATH.$path) && $path!="")

					{

						$this->data["location_image"]  = base_url()."image/default/150/150/no_available_image.gif"; 

					}

					else{

						$this->data["location_image"] = base_url().$path; 

					}





					$special_offer_path = 'assets/upload/locations/'.$id.'/'.$this->data["location_data"]["offer_image"];



					if(!file_exists(FCPATH.$special_offer_path))

					{

						$this->data["special_offer_image"]  = base_url()."image/default/150/150/no_available_image.gif"; 

					}

					else{

						$this->data["special_offer_image"] = base_url().$path; 

					}

					$this->load->start_inline_scripting();

					echo "Appad.init_mng_cities_operation();";

					echo "Appad.init_common_methods();";			

					$this->load->end_inline_scripting(false,false);



				}

				else{

					$this->session->set_flashdata("error",lang(INVALID_REQUEST));

					redirect(base_url().$this->page,"refresh");

				}

			}

		}

	}

	

	public function change_status()

	{

		if($this->isAjax)

		{

			$this->layout=false;

			$this->view=false;

			$this->json=true;	

			$this->data["status"] = "fail";

			$this->data["msg"] = "";		

			$location_id = $this->input->post('location_id');

			$upd_status = 'n';

			$msg_constant = MSG_REC_DEACTIVE;

			if($location_id > 0){

				$this->location_data = $this->locations_model->set_fields("id,status")->as_array()->get($location_id);

				if(!empty($this->location_data))

				{

					if($this->location_data['status'] == 'n')

					{

						$upd_status = 'y';

						$msg_constant = MSG_REC_ACTIVE;

					}

					$update_array = array('status' => $upd_status);

					$response = $this->locations_model->update($location_id,$update_array,true);

					$this->data["status"] = "success";

					$this->data["msg"] = lang($msg_constant);	

				}

			}

		}

	}

	public function delete($id){

		$this->data["status"] = "fail";

		$this->data["msg"] = "Please try again.";

		$this->view = false;

		$this->layout = false;

		$this->json = true;

		if($id > 0)

		{

			$del_status = $this->locations_model->delete($id);

			if($del_status)

			{

				$this->data["status"] = "success";

				$this->data["msg"] = lang(MSG_REC_DELETE);

				$this->data["table"] = "tblmng_pickup_location";

			}

		}

	}

}

