<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_facilities_promo_code extends MY_Controller {

	function __construct()

	{

		$this->login_type	= 'admin';

		$this->access   = 'login';

		parent::__construct();

		$this->_init();

		$this->modal_name = "facilities_promo_code_model";

		$this->load->model($this->modal_name);

		$this->page ='admin/manage_facilities_promo_code/';

		$this->current_url = base_url()."admin/manage_facilities_promo_code/";

		$this->table_id = "tblmng_facility_promo_code";

	}

	

	private function _init()

	{

		$this->sections['section_header'] = 'sections/admin/header';

		$this->sections['section_sidebar'] = 'sections/admin/menu';

		$this->sections['section_footer'] = 'sections/admin/footer';		

	}

	public function index()

	{

		$this->grid_resorces();

		$text = "Manage Facilities Promo Code";

		$this->output->set_title(lang($text));

		$this->page_name = lang($text);

		$this->data['add_button'] = true;

		$this->data['add_button_href'] = $this->current_url.'add';

		$this->data['tbl_id']		=	$this->table_id;

		$this->load->start_inline_scripting();

		echo "Appad.init_mng_facility_promo_code();";

		$this->load->end_inline_scripting(false,false);

		$this->view = "layouts/admin/datatable";		

		$editurl = $this->current_url."edit";

		$deleteurl = $this->current_url."delete";

		$array = array('edit'=>$editurl,'delete'=>$deleteurl);

		$this->load->library('Datatables');

		$this->load->helper('datatable_helper');

		$this->datatables->select('fpc.id,f.facility_name,fpc.start_date,fpc.end_date,fpc.type,fpc.amount,fpc.status',false)

		->join('car_facilities as f','f.id = fpc.facilityId')

		->edit_column('status', '$1', 'get_status(status,id,"")')

		->edit_column('type', '$1', 'get_facility_promo_type(type,id)')

		->add_column('operation',get_operation_btn('$1',$array),'id')

		->from('facilities_promo_code as fpc');

		if($this->isAjax){

			$this->layout=false;

			$this->view=false;

			echo $this->datatables->generate();

			exit;

		}

		$results = $this->datatables->generate('raw');

		$this->data['columns'] = $results['columns'];

	}

	public function add()

	{

		$data = array();

		if($this->input->post())

		{

			$facilityId = $this->input->post('facilityId');

			$type = $this->input->post('type');

			$default_selected = $this->input->post('default_selected');

			$start_date = $this->input->post('start_date');

			$end_date = $this->input->post('end_date');

			$amount = $this->input->post('price');

			$all_cars = $this->input->post('all_cars');

			$where_ar[] = array("(('".$start_date."' BETWEEN start_date AND end_date) OR ('".$end_date."' BETWEEN start_date AND end_date)) AND facilityId = '".$facilityId."'",null,false);

			$exist_check = $this->{$this->modal_name}->get_by($where_ar);

			if(!empty($exist_check))

			{

				$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));

				redirect($this->current_url."add");	

			}

			else{

				$data = array(

					'facilityId' => $facilityId,

					'type' => $type,

					'default_selected' => $default_selected,

					'amount' => $amount,					

					'start_date' => $start_date,

					'all_cars' => $all_cars,

					'end_date' => $end_date,

					'created' => date('Y-m-d H:i:s')					

					);

				$status = $this->{$this->modal_name}->insert($data);

				if($status)

				{

					$this->session->set_flashdata('success',lang(MSG_REC_ADD));

					redirect($this->current_url);				

				}else{

					$this->session->set_flashdata('error',lang(validation_errors()));

					redirect($this->current_url."add");	

				}				

			}

		}

		if(!$this->input->post())

		{

			$this->load->model("car_facilities_model");

			$this->load->js('js/components-date-time-pickers.js');

			$this->page_type = 'add';

			$text = "Add Facilities Promo Code";

			$this->page_name = lang($text);

			$this->output->set_title(lang($text));

			$this->data["form_url"] = $this->current_url."add";

			$where_fac_ar = array('status'=>'y');

			$this->car_facilities_model->after_get_allow = false;

			$this->data["facilities"] = $this->car_facilities_model->set_fields("id,facility_name")->get_many_by($where_fac_ar);

			$this->car_facilities_model->after_get_allow = true;

			$this->load->model("cars_model");

			$this->cars_model->after_get_allow = false;

			$this->data["cars"] = $this->cars_model->set_fields("id,name")->get_many_by('status','y');

			$this->cars_model->after_get_allow = true;

			$this->load->start_inline_scripting();

			echo "Appad.init_mng_facility_promo_code_operations();";

			$this->load->end_inline_scripting(false,false);

			$this->view = $this->page."add_edit";

		}

	}

	public function edit($id=NULL){

		if($id != NULL && $id > 0){

			$data = array();

			$this->data["promo_data"] = $this->{$this->modal_name}->as_array()->get($id);

			$animeties_array = array("db_sel_cars");

			$this->data["promo_data"] = $this->{$this->modal_name}->as_array()->get($id);

			if(!empty($animeties_array))

			{

				foreach ($animeties_array as $key => $value) {

					if(!empty($this->data["promo_data"][$value]))

					{

						$this->data["promo_data"][$value."_ids"] = array();

						foreach ($this->data["promo_data"][$value] as $key => $value1) {

							$this->data["promo_data"][$value."_ids"][] = $value1["carId"];

						}

						unset($this->data["promo_data"][$value]);

					}	

				}

			}

			if($this->input->post())

			{

				$facilityId = $this->input->post('facilityId');

				$type = $this->input->post('type');

				$default_selected = $this->input->post('default_selected');

				$start_date = $this->input->post('start_date');

				$end_date = $this->input->post('end_date');

				$amount = $this->input->post('price');

				$all_cars = $this->input->post('all_cars');

				$where_ar[] = array("(('".$start_date."' BETWEEN start_date AND end_date) OR ('".$end_date."' BETWEEN start_date AND end_date)) AND facilityId = '".$facilityId."'",null,false);

				$where_ar[] = array("id != '".$id."'",null,false);

				$exist_check = $this->{$this->modal_name}->get_by($where_ar);

				if(!empty($exist_check))

				{

					$this->session->set_flashdata('error',lang(MSG_REC_EXISTS));

					redirect($this->current_url."edit/".$id);	

				}

				else{				

					$data = array(

						'facilityId' => $facilityId,

						'type' => $type,

						'default_selected' => $default_selected,

						'amount' => $amount,					

						'start_date' => $start_date,

						'end_date' => $end_date,

						'all_cars' => $all_cars,

						"db_sel_cars"=>	$this->data["promo_data"]["db_sel_cars_ids"],

						"id"=>$id					

						);

					if(!empty($data))

					{

						$update_status = $this->{$this->modal_name}->update($id,$data);

						if(!empty($update_status)) 

						{

							$this->session->set_flashdata('success',lang(MSG_REC_EDIT));

							redirect($this->current_url,"refresh");

						}else{

							$this->session->set_flashdata('error',lang(MSG_FILL_ALL_FIELDS));

							redirect($this->current_url.'edit/'.$id,"refresh");

						}

					}					

				}

			}

			else if(!$this->input->post())

			{

				$this->load->js('js/components-date-time-pickers.js');

				if($this->data["promo_data"])

				{

					$this->load->model("car_facilities_model");

					$text = "Edit facility promo code";

					$this->page_type = 'edit';

					$this->page_name = lang($text);

					$this->output->set_title(lang($text));

					$this->data["form_url"] = $this->current_url.'edit/'.$id;	

					$this->data["action"] = "edit";

					

					$this->car_facilities_model->after_get_allow = false;

					$this->data["facilities"] = $this->car_facilities_model->set_fields("id,facility_name")->get_many_by('status','y');

					$this->car_facilities_model->after_get_allow = true;

					$this->load->model("cars_model");



					$this->cars_model->after_get_allow = false;

					$this->data["cars"] = $this->cars_model->set_fields("id,name")->get_many_by('status','y');

					$this->cars_model->after_get_allow = true;

					

					$this->load->start_inline_scripting();

					echo "Appad.init_mng_facility_promo_code_operations();";

					$this->load->end_inline_scripting(false,false);

					if($this->data["promo_data"]["all_cars"] == "1")

					{

						$this->data["checked"] = true;						

					}

					$this->view = $this->page."add_edit";

				}

				else{

					$this->session->set_flashdata("error",lang(INVALID_REQUEST));

					redirect(base_url().$this->page,"refresh");

				}

			}

		}

	}

	public function change_status()

	{

		if($this->isAjax)

		{

			$this->layout=false;

			$this->view=false;

			$this->json=true;	

			$this->data["status"] = "fail";

			$this->data["msg"] = "";		

			$facility_id = $this->input->post('facility_id');

			$upd_status = 'n';

			$msg_constant = MSG_REC_DEACTIVE;

			if($facility_id > 0){

				$this->status_data = $this->{$this->modal_name}->set_fields("id,status")->as_array()->get($facility_id);

				if(!empty($this->status_data))

				{

					if($this->status_data['status'] == 'n'){

						$upd_status = 'y';

						$msg_constant = MSG_REC_ACTIVE;

					}

					$update_array = array('status' => $upd_status);

					$response = $this->{$this->modal_name}->update($facility_id,$update_array,true);

					$this->data["status"] = "success";

					$this->data["msg"] = lang($msg_constant);	

				}

			}

		}

	}

	public function delete($id){

		$this->data["status"] = "fail";

		$this->data["msg"] = "Please try again.";

		$this->view = false;

		$this->layout = false;

		$this->json = true;

		if($id > 0){

			$del_status = $this->{$this->modal_name}->delete($id);

			if($del_status)

			{

				$this->data["status"] = "success";

				$this->data["msg"] = lang(MSG_REC_DELETE);

				$this->data["table"] = $this->table_id;

			}

		}

	}

}

